//made by mathisall math-is-all@outlook.com
document.addEventListener('DOMContentLoaded', function() {
  const audioPlayer = document.getElementById('audioPlayer');
  const fileChooser = document.getElementById('fileChooser');
  const playbackSpeed = document.getElementById('playbackSpeed');
  const speedValue = document.getElementById('speedValue');

  // 当用户选择文件时更新播放器
  fileChooser.addEventListener('change', function(event) {
    const files = event.target.files;
    if (files.length === 0) {
      return;
    }

    const file = files[0];
    audioPlayer.src = URL.createObjectURL(file);
    audioPlayer.load();
    audioPlayer.play();
  });

  // 更新播放速度
  playbackSpeed.addEventListener('input', function() {
    const speed = playbackSpeed.value;
    audioPlayer.playbackRate = speed;
    speedValue.textContent = `${speed}x`;
  });
});
